#ifdef PRECOMPILEDHEADERS
	#include "TileEngine All.h"
#else
	#include "tiledef.h"
	#include "worlddef.h"
#endif

#include "tchar.h"
#include "windowsx.h"

//<SB>
int gNumberOfTiles;

INT16 gFirstTileOfType[NUMBEROFTILETYPES];
//</SB>

INT16 gOpenDoorList[20] =
{
	FIRSTDOOR1,
	SECONDDOOR1,
	THIRDDOOR1,
	FOURTHDOOR1,
	FIRSTDOOR6,
	SECONDDOOR6,
	THIRDDOOR6,
	FOURTHDOOR6,
	FIRSTDOOR11,
	SECONDDOOR11,
	THIRDDOOR11,
	FOURTHDOOR11,
	FIRSTDOOR16,
	SECONDDOOR16,
	THIRDDOOR16,
	FOURTHDOOR16,
	-1
};

INT16 gOpenDoorShadowList[20] =
{
	FIRSTDOORSH1,
	SECONDDOORSH1,
	THIRDDOORSH1,
	FOURTHDOORSH1,
	FIRSTDOORSH6,
	SECONDDOORSH6,
	THIRDDOORSH6,
	FOURTHDOORSH6,
	FIRSTDOORSH11,
	SECONDDOORSH11,
	THIRDDOORSH11,
	FOURTHDOORSH11,
	FIRSTDOORSH16,
	SECONDDOORSH16,
	THIRDDOORSH16,
	FOURTHDOORSH16,
	-1
};

INT16 gClosedDoorList[20] =
{
	FIRSTDOOR5,
	SECONDDOOR5,
	THIRDDOOR5,
	FOURTHDOOR5,
	FIRSTDOOR10,
	SECONDDOOR10,
	THIRDDOOR10,
	FOURTHDOOR10,
	FIRSTDOOR15,
	SECONDDOOR15,
	THIRDDOOR15,
	FOURTHDOOR15,
	FIRSTDOOR20,
	SECONDDOOR20,
	THIRDDOOR20,
	FOURTHDOOR20,
	-1
};

INT16 gClosedDoorShadowList[20] =
{
	FIRSTDOORSH5,
	SECONDDOORSH5,
	THIRDDOORSH5,
	FOURTHDOORSH5,
	FIRSTDOORSH10,
	SECONDDOORSH10,
	THIRDDOORSH10,
	FOURTHDOORSH10,
	FIRSTDOORSH15,
	SECONDDOORSH15,
	THIRDDOORSH15,
	FOURTHDOORSH15,
	FIRSTDOORSH20,
	SECONDDOORSH20,
	THIRDDOORSH20,
	FOURTHDOORSH20,
	-1
};



// REVERSE BUDDIES FROM SHADOW BACK TO STRUCT
INT16 gReverseShadowBuddys[] =
{
	FIRSTCLIFFSHADOW,			FIRSTCLIFFSHADOW1,			FIRSTCLIFF1,

	FIRSTSHADOW,					FIRSTSHADOW1,						FIRSTOSTRUCT1,
	SECONDSHADOW,					SECONDSHADOW1,					SECONDOSTRUCT1,
	THIRDSHADOW,					THIRDSHADOW1,						THIRDOSTRUCT1,
	FOURTHSHADOW,					FOURTHSHADOW1,					FOURTHOSTRUCT1,
	FIFTHSHADOW,					FIFTHSHADOW1,						FIFTHOSTRUCT1,
	SIXTHSHADOW,					SIXTHSHADOW1,						SIXTHOSTRUCT1,
	SEVENTHSHADOW,				SEVENTHSHADOW1,					SEVENTHOSTRUCT1,
	EIGHTSHADOW,					EIGHTSHADOW1,						EIGHTOSTRUCT1,

	FIRSTFULLSHADOW,			FIRSTFULLSHADOW1,				FIRSTFULLSTRUCT1,
	SECONDFULLSHADOW,			SECONDFULLSHADOW1,			SECONDFULLSTRUCT1,
	THIRDFULLSHADOW,			THIRDFULLSHADOW1,				THIRDFULLSTRUCT1,
	FOURTHFULLSHADOW,			FOURTHFULLSHADOW1,			FOURTHFULLSTRUCT1,
	
	FIRSTDOORSHADOW,			FIRSTDOORSH1,						FIRSTDOOR1,
	SECONDDOORSHADOW,			SECONDDOORSH1,					SECONDDOOR1,
	THIRDDOORSHADOW,			THIRDDOORSH1,						THIRDDOOR1,
	FOURTHDOORSHADOW,			FOURTHDOORSH1,					FOURTHDOOR1,

	//FENCE
	FENCESHADOW,					FENCESHADOW1,						FENCESTRUCT1,

	// VEHICLES
	FIRSTVEHICLESHADOW,		FIRSTVEHICLESHADOW1,		FIRSTVEHICLE1,
	SECONDVEHICLESHADOW,	SECONDVEHICLESHADOW1,		SECONDVEHICLE1,

	//DebrisSTRUCT
	FIRSTDEBRISSTRUCTSHADOW,		FIRSTDEBRISSTRUCTSHADOW1,				FIRSTDEBRISSTRUCT1,
	SECONDDEBRISSTRUCTSHADOW,		SECONDDEBRISSTRUCTSHADOW1,			SECONDDEBRISSTRUCT1,

	NINTHOSTRUCTSHADOW,					NINTHOSTRUCTSHADOW1,						NINTHOSTRUCT1,
	TENTHOSTRUCTSHADOW,					TENTHOSTRUCTSHADOW1,						TENTHOSTRUCT1,

	FIRSTLARGEEXPDEBRISSHADOW,	FIRSTLARGEEXPDEBRISSHADOW1,			FIRSTLARGEEXPDEBRIS1,
	SECONDLARGEEXPDEBRISSHADOW,	SECONDLARGEEXPDEBRISSHADOW1,			SECONDLARGEEXPDEBRIS1,

	-1
};


// SHADOW BUDDIES FROM STRUCT FORWARD TO SHADOW
INT16 gForwardShadowBuddys[] =
{
	FIRSTCLIFF,						FIRSTCLIFF1,							FIRSTCLIFFSHADOW1,

	FIRSTOSTRUCT,					FIRSTOSTRUCT1,						FIRSTSHADOW1,
	SECONDOSTRUCT,				SECONDOSTRUCT1,						SECONDSHADOW1,
	THIRDOSTRUCT,					THIRDOSTRUCT1,						THIRDSHADOW1,
	FOURTHOSTRUCT,				FOURTHOSTRUCT1,						FOURTHSHADOW1,
	FIFTHOSTRUCT,					FIFTHOSTRUCT1,						FIFTHSHADOW1,
	SIXTHOSTRUCT,					SIXTHOSTRUCT1,						SIXTHSHADOW1,
	SEVENTHOSTRUCT,				SEVENTHOSTRUCT1,					SEVENTHSHADOW1,
	EIGHTOSTRUCT,					EIGHTOSTRUCT1,						EIGHTSHADOW1,

	FIRSTFULLSTRUCT,			FIRSTFULLSTRUCT1,				  FIRSTFULLSHADOW1,
	SECONDFULLSTRUCT,			SECONDFULLSTRUCT1,			  SECONDFULLSHADOW1,
	THIRDFULLSTRUCT,			THIRDFULLSTRUCT1,				  THIRDFULLSHADOW1,
	FOURTHFULLSTRUCT,			FOURTHFULLSTRUCT1,			  FOURTHFULLSHADOW1,
	
	FIRSTDOOR,						FIRSTDOOR1,								FIRSTDOORSH1,
	SECONDDOOR,						SECONDDOOR1,							SECONDDOORSH1,
	THIRDDOOR,						THIRDDOOR1,								THIRDDOORSH1,
	FOURTHDOOR,						FOURTHDOOR1,							FOURTHDOORSH1,

	//FENCE
	FENCESTRUCT,					FENCESTRUCT1,							FENCESHADOW1,

	// VEHICLE
	FIRSTVEHICLE,					FIRSTVEHICLE1,						FIRSTVEHICLESHADOW1,
	SECONDVEHICLE,				SECONDVEHICLE1,						SECONDVEHICLESHADOW1,

	FIRSTDEBRISSTRUCT,		FIRSTDEBRISSTRUCT1,				FIRSTDEBRISSTRUCTSHADOW1,
	SECONDDEBRISSTRUCT,		SECONDDEBRISSTRUCT1,			SECONDDEBRISSTRUCTSHADOW1,

	NINTHOSTRUCT,					NINTHOSTRUCT1,						NINTHOSTRUCTSHADOW1,
	TENTHOSTRUCT,					TENTHOSTRUCT1,						TENTHOSTRUCTSHADOW1,

	FIRSTLARGEEXPDEBRIS,	FIRSTLARGEEXPDEBRIS1,			FIRSTLARGEEXPDEBRISSHADOW1,
	SECONDLARGEEXPDEBRIS,	SECONDLARGEEXPDEBRIS1,		SECONDLARGEEXPDEBRISSHADOW1,

	-1

};

// Global variable used to initialize tile database with full tile spec
UINT8	gFullBaseTileValues[] = 

{	
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // First Texture
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // Second Texture
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // Third Texture
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // Forth Texture
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // Fifth Texture
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0,

	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // Sixth Texture
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // Seventh Texture
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0,

	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // Water1 Texture
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 

	1, 1, 1, 1, 1, 1, 1, 1, 1, 1 // Water2 Texture

};


STR gTileSurfaceName[NUMBEROFTILETYPES] =
{
"TEXTURE1",
"TEXTURE2",
"TEXTURE3",
"TEXTURE4",
"TEXTURE5",
"TEXTURE6",
"TEXTURE7",
"WATER1",
"DEEP WATER",
"FIRSTCLIFFHANG",
"FIRSTCLIFF",
"FIRSTCLIFFSHADOW",
"OSTRUCT1",
"OSTRUCT2",
"OSTRUCT3",
"OSTRUCT4",
"OSTRUCT5",
"OSTRUCT6",
"OSTRUCT7",
"OSTRUCT8",
"OFSTRUCT1",
"OFSTRUCT2",
"PLACEHOLDER1",
"PLACEHOLDER2",

"SHADOW1",
"SHADOW2",
"SHADOW3",
"SHADOW4",
"SHADOW5",
"SHADOW6",
"SHADOW7",
"SHADOW8",
"FSHADOW1",
"FSHADOW2",
"PLACEHOLDER3",
"PLACEHOLDER4",

"WALL1",
"WALL2",
"WALL3",
"WALL4",
"DOOR1",
"DOOR2",
"DOOR3",
"DOOR4",
"DOORSH1",
"DOORSH2",
"DOORSH3",
"DOORSH4",
"SLANTFLATPEICE",
"ANOTHERDEBRIS",
"ROADPIECES",
"WINDOW4",
"DECORATIONS1",
"DECORATIONS2",
"DECORATIONS3",
"DECORATIONS4",
"WALLDECAL1",
"WALLDECAL2",
"WALLDECAL3",
"WALLDECAL4",
"FLOOR1",
"FLOOR2",
"FLOOR3",
"FLOOR4",
"ROOF1",
"ROOF2",
"ROOF3",
"ROOF4",
"SROOF1",
"SROOF2",
"ONROOF1",
"ONROOF2",
"MOCKF1",

"ISTRUCT1",
"ISTRUCT2",
"ISTRUCT3",
"ISTRUCT4",

"FIRSTCISTRCUT",

"FIRSTROAD",

"ROCKS",
"WOOD",
"WEEDS",
"GRASS",
"SAND",
"MISC",

"ANIOSTRUCT",
"FENCESTRUCT",
"FENCESHADOW",

"FIRSTVEHICLE",
"SECONDVEHICLE",
"FIRSTVEHICLESHADOW",
"SECONDVEHICLESHADOW",
"MISC2",
"FIRSTDEBRISSTRUCT",
"SECONDDEBRISSTRUCT",
"FIRSTDEBRISSTRUCTSHADOW",
"SECONDDEBRISSTRUCTSHADOW",
"NINTHOSTRUCT",
"TENTHOSTRUCT",
"NINTHOSTRUCTSHADOW",
"TENTHOSTRUCTSHADOW",

"FIRSTEXPLODEDEBRIS",
"SECONDEXPLODEDEBRIS",
"FIRSTLARGEEXPLODEDEBRIS",
"SECONDLARGEEXPLODEDEBRIS",
"FIRSTLARGEEXPLODEDEBRISSHADOW",
"SECONDLARGEEXPLODEDEBRISSHADOW",

"FIFTHISTRUCT",
"SIXTHISTRUCT",
"SEVENTHISTRUCT",
"EIGHTISTRUCT",

"FIRSTHIGHROOF",
"SECONDHIGHROOF",

"WALLDECAL5",
"WALLDECAL6",
"WALLDECAL7",
"WALLDECAL8",

"HUMANBLOOD",
"CREATUREBLOOD",
"FIRSTSWITCHES",

// ABSOLUTELY NO STUFF PAST HERE!
// CAN BE SAVED IN THE MAP DIRECTLY!
"REVEALEDSLANTROOF",
"1stREVEALEDHIGHROOF",
"2ndREVEALEDHIGHROOF",

"GUNS",
"ITEMS",
"ITEMS2",

"GLASSSHATTER",
"ITEMS3",
"BODYBLOW",

"EXITTEXTURE",
"FOOTPRINTS",
"POINTERS",
"POINTERS2",
"POINTERS3",

"GOODRUN",
"GOODWALK",
"GOODSWAT",
"GOODSCOOT",
"CONFIRMMOVE",
"VEHICLEMOVE",
"ACTIONTWO",
"BADMARKER",
"GRING",
"ROTATINGKEY",
"SELRING",
"SPECIAL",
"BULLET",
"MISS1",
"MISS2",
"MISS3",
"WIREFRAME"
};


UINT16	gNumTilesPerType[ NUMBEROFTILETYPES ];

UINT8	gTileTypeLogicalHeight[ NUMBEROFTILETYPES ] =
{
	2,						// First texture
	2,						// Second texture
	2,						// Third texture
	2,						// Forth texture
	2,						// Fifth texture
	2,						// Sixth texture
	2,						// Seventh texture
	10,						// First water
	10							// Second water
};

//
int gWrote = FALSE;
//
//<SB>
#define TILETYPE_TAG	"TILETYPE"

int WriteTileIniSettings()
{
	int i;
	TCHAR tsFullIniPath[MAX_PATH];
	TCHAR tsSectionName[16] = TILETYPE_TAG;
	TCHAR	tsNum[16];
//	UINT16	gNumTilesPerType[ NUMBEROFTILETYPES ]
	GetModuleFileName(NULL,tsFullIniPath,MAX_PATH);
	_tcscpy(_tcsrchr(tsFullIniPath,'\\'),_T("\\tile.ini"));

	for( i=0; i<NUMBEROFTILETYPES; i++ )
	{
		_itot( i, tsSectionName+_tcslen(TILETYPE_TAG), 10);
		WritePrivateProfileString(tsSectionName, _T("name"), gTileSurfaceName[i], tsFullIniPath);
		WritePrivateProfileString(tsSectionName, _T("frames"), _itot(gNumTilesPerType[i],tsNum,10), tsFullIniPath);
	}
	return 1;
}


int GetTileIniSettings(TCHAR * tsIniPath, HWND hConsole)
{
	int i;
	TCHAR tsFullIniPath[MAX_PATH];
	TCHAR tsSectionName[16] = TILETYPE_TAG;
	int count = 0;

	_tcscpy(tsFullIniPath,tsIniPath);
	_tcscat(tsFullIniPath,_T("\\tile.ini"));
	// Get calibres
	Edit_ReplaceSel(hConsole,"\r\nloading_tile_data...");
	for( i=0; i<NUMBEROFTILETYPES; i++ )
	{
		gFirstTileOfType[i] = count;
		_itot( i, tsSectionName+_tcslen(TILETYPE_TAG), 10);
		gNumTilesPerType[i] = (INT16)GetPrivateProfileInt(tsSectionName, _T("frames"), 10, tsFullIniPath);
		count += gNumTilesPerType[i];
	}
	gNumberOfTiles = count;
	Edit_ReplaceSel(hConsole,"done");

	i = 0;
	while(gOpenDoorList[i] != -1)
		gOpenDoorList[i++] += gFirstTileOfType[FIRSTDOOR] - FIRSTDOOR1;
	i = 0;
	while(gOpenDoorShadowList[i] != -1)
		gOpenDoorShadowList[i++] += gFirstTileOfType[FIRSTDOOR] - FIRSTDOOR1;
	i = 0;
	while(gClosedDoorList[i] != -1)
		gClosedDoorList[i++] += gFirstTileOfType[FIRSTDOOR] - FIRSTDOOR1;
	i = 0;
	while(gClosedDoorShadowList[i] != -1)
		gClosedDoorShadowList[i++] += gFirstTileOfType[FIRSTDOOR] - FIRSTDOOR1;

	gReverseShadowBuddys[0*3+1] = gForwardShadowBuddys [0*3+2] = gFirstTileOfType[FIRSTCLIFFSHADOW];
	gReverseShadowBuddys[0*3+2] = gForwardShadowBuddys [0*3+1] = gFirstTileOfType[FIRSTCLIFF];

	gReverseShadowBuddys[1*3+1] = gForwardShadowBuddys [1*3+2] = gFirstTileOfType[FIRSTSHADOW];
	gReverseShadowBuddys[1*3+2] = gForwardShadowBuddys [1*3+1] = gFirstTileOfType[FIRSTOSTRUCT];

	gReverseShadowBuddys[2*3+1] = gForwardShadowBuddys [2*3+2] = gFirstTileOfType[SECONDSHADOW];
	gReverseShadowBuddys[2*3+2] = gForwardShadowBuddys [2*3+1] = gFirstTileOfType[SECONDOSTRUCT];

	gReverseShadowBuddys[3*3+1] = gForwardShadowBuddys [3*3+2] = gFirstTileOfType[THIRDSHADOW];
	gReverseShadowBuddys[3*3+2] = gForwardShadowBuddys [3*3+1] = gFirstTileOfType[THIRDOSTRUCT];

	gReverseShadowBuddys[4*3+1] = gForwardShadowBuddys [4*3+2] = gFirstTileOfType[FOURTHSHADOW];
	gReverseShadowBuddys[4*3+2] = gForwardShadowBuddys [4*3+1] = gFirstTileOfType[FOURTHOSTRUCT];

	gReverseShadowBuddys[5*3+1] = gForwardShadowBuddys [5*3+2] = gFirstTileOfType[FIFTHSHADOW];
	gReverseShadowBuddys[5*3+2] = gForwardShadowBuddys [5*3+1] = gFirstTileOfType[FIFTHOSTRUCT];

	gReverseShadowBuddys[6*3+1] = gForwardShadowBuddys [6*3+2] = gFirstTileOfType[SIXTHSHADOW];
	gReverseShadowBuddys[6*3+2] = gForwardShadowBuddys [6*3+1] = gFirstTileOfType[SIXTHOSTRUCT];

	gReverseShadowBuddys[7*3+1] = gForwardShadowBuddys [7*3+2] = gFirstTileOfType[SEVENTHSHADOW];
	gReverseShadowBuddys[7*3+2] = gForwardShadowBuddys [7*3+1] = gFirstTileOfType[SEVENTHOSTRUCT];

	gReverseShadowBuddys[8*3+1] = gForwardShadowBuddys [8*3+2] = gFirstTileOfType[EIGHTSHADOW];
	gReverseShadowBuddys[8*3+2] = gForwardShadowBuddys [8*3+1] = gFirstTileOfType[EIGHTOSTRUCT];

	gReverseShadowBuddys[9*3+1] = gForwardShadowBuddys [9*3+2] = gFirstTileOfType[FIRSTFULLSHADOW];
	gReverseShadowBuddys[9*3+2] = gForwardShadowBuddys [9*3+1] = gFirstTileOfType[FIRSTFULLSTRUCT];

	gReverseShadowBuddys[10*3+1] = gForwardShadowBuddys [10*3+2] = gFirstTileOfType[SECONDFULLSHADOW];
	gReverseShadowBuddys[10*3+2] = gForwardShadowBuddys [10*3+1] = gFirstTileOfType[SECONDFULLSTRUCT];

	gReverseShadowBuddys[11*3+1] = gForwardShadowBuddys [11*3+2] = gFirstTileOfType[THIRDFULLSHADOW];
	gReverseShadowBuddys[11*3+2] = gForwardShadowBuddys [11*3+1] = gFirstTileOfType[THIRDFULLSTRUCT];

	gReverseShadowBuddys[12*3+1] = gForwardShadowBuddys [120*3+2] = gFirstTileOfType[FOURTHFULLSHADOW];
	gReverseShadowBuddys[12*3+2] = gForwardShadowBuddys [12*3+1] = gFirstTileOfType[FOURTHFULLSTRUCT];
	
	gReverseShadowBuddys[13*3+1] = gForwardShadowBuddys [13*3+2] = gFirstTileOfType[FIRSTDOORSHADOW];
	gReverseShadowBuddys[13*3+2] = gForwardShadowBuddys [13*3+1] = gFirstTileOfType[FIRSTDOOR];

	gReverseShadowBuddys[14*3+1] = gForwardShadowBuddys [14*3+2] = gFirstTileOfType[SECONDDOORSHADOW];
	gReverseShadowBuddys[14*3+2] = gForwardShadowBuddys [14*3+1] = gFirstTileOfType[SECONDDOOR];

	gReverseShadowBuddys[15*3+1] = gForwardShadowBuddys [15*3+2] = gFirstTileOfType[THIRDDOORSHADOW];
	gReverseShadowBuddys[15*3+2] = gForwardShadowBuddys [15*3+1] = gFirstTileOfType[THIRDDOOR];

	gReverseShadowBuddys[16*3+1] = gForwardShadowBuddys [16*3+2] = gFirstTileOfType[FOURTHDOORSHADOW];
	gReverseShadowBuddys[16*3+2] = gForwardShadowBuddys [16*3+1] = gFirstTileOfType[FOURTHDOOR];

	//FENCE
	gReverseShadowBuddys[17*3+1] = gForwardShadowBuddys [17*3+2] = gFirstTileOfType[FENCESHADOW];
	gReverseShadowBuddys[17*3+2] = gForwardShadowBuddys [17*3+1] = gFirstTileOfType[FENCESTRUCT];

	// VEHICLES
	gReverseShadowBuddys[18*3+1] = gForwardShadowBuddys [18*3+2] = gFirstTileOfType[FIRSTVEHICLESHADOW];
	gReverseShadowBuddys[18*3+2] = gForwardShadowBuddys [18*3+1] = gFirstTileOfType[FIRSTVEHICLE];

	gReverseShadowBuddys[19*3+1] = gForwardShadowBuddys [19*3+2] = gFirstTileOfType[SECONDVEHICLESHADOW];
	gReverseShadowBuddys[19*3+2] = gForwardShadowBuddys [19*3+1] = gFirstTileOfType[SECONDVEHICLE];

	//DebrisSTRUCT
	gReverseShadowBuddys[20*3+1] = gForwardShadowBuddys [20*3+2] = gFirstTileOfType[FIRSTDEBRISSTRUCTSHADOW];
	gReverseShadowBuddys[20*3+2] = gForwardShadowBuddys [20*3+1] = gFirstTileOfType[FIRSTDEBRISSTRUCT];

	gReverseShadowBuddys[21*3+1] = gForwardShadowBuddys [21*3+2] = gFirstTileOfType[SECONDDEBRISSTRUCTSHADOW];
	gReverseShadowBuddys[21*3+2] = gForwardShadowBuddys [21*3+1] = gFirstTileOfType[SECONDDEBRISSTRUCT];

	gReverseShadowBuddys[22*3+1] = gForwardShadowBuddys [22*3+2] = gFirstTileOfType[NINTHOSTRUCTSHADOW];
	gReverseShadowBuddys[22*3+2] = gForwardShadowBuddys [22*3+1] = gFirstTileOfType[NINTHOSTRUCT];

	gReverseShadowBuddys[23*3+1] = gForwardShadowBuddys [23*3+2] = gFirstTileOfType[TENTHOSTRUCTSHADOW];
	gReverseShadowBuddys[23*3+2] = gForwardShadowBuddys [23*3+1] = gFirstTileOfType[TENTHOSTRUCT];

	gReverseShadowBuddys[24*3+1] = gForwardShadowBuddys [24*3+2] = gFirstTileOfType[FIRSTLARGEEXPDEBRISSHADOW];
	gReverseShadowBuddys[24*3+2] = gForwardShadowBuddys [24*3+1] = gFirstTileOfType[FIRSTLARGEEXPDEBRIS];

	gReverseShadowBuddys[25*3+1] = gForwardShadowBuddys [25*3+2] = gFirstTileOfType[SECONDLARGEEXPDEBRISSHADOW];
	gReverseShadowBuddys[25*3+2] = gForwardShadowBuddys [25*3+1] = gFirstTileOfType[SECONDLARGEEXPDEBRIS];

	return 1;
}
//</SB>

void	SetSpecificDatabaseValues( UINT16 usType, UINT16 uiDatabaseElem, TILE_ELEMENT *TileElement, BOOLEAN fUseRaisedObjectType )
{
	UINT8						ubLoop;
	INT16						sIndexDiff;
	UINT32					cnt;

//	if(!gWrote)
//	{
//		WriteTileIniSettings();
//		gWrote = TRUE;
//	}

	// SETUP BUDDYS FOR SHADOWS
	cnt = 0;
	while( gReverseShadowBuddys[ cnt ] != -1 )
	{
		// IF WE ARE A SHADOW TYPE
		if ( usType == gReverseShadowBuddys[ cnt ] )
		{
			TileElement->sBuddyNum = gReverseShadowBuddys[ cnt + 2 ] + ( uiDatabaseElem - gReverseShadowBuddys[ cnt + 1 ] );

			// Check flags and made the same, take from buddy's
			TileElement->uiFlags |= gTileDatabase[ TileElement->sBuddyNum ].uiFlags;
		}

		cnt+=3;
	};

	// SETUP BUDDYS THAT GO FROM STRUCT TO SHADOW
	cnt = 0;
	while( gForwardShadowBuddys[ cnt ] != -1 )
	{
		// IF WE ARE A SHADOW TYPE
		if ( usType == gForwardShadowBuddys[ cnt ] )
		{
			TileElement->sBuddyNum = gForwardShadowBuddys[ cnt + 2 ] + ( uiDatabaseElem - gForwardShadowBuddys[ cnt + 1 ] );
			// Set flag indicating such
			TileElement->uiFlags |= HAS_SHADOW_BUDDY;
		}
		cnt+=3;
	};

	

	if ( uiDatabaseElem >= gFirstTileOfType[FIRSTDOOR] && 
			 uiDatabaseElem <= gFirstTileOfType[FOURTHDOORSHADOW]+19 )
	{
		// Door anims
		// Open
		cnt = 0;
		while( gOpenDoorList[ cnt ] != -1 )
		{
			// IF WE ARE A SHADOW TYPE
			if ( uiDatabaseElem == gOpenDoorList[ cnt ] )
			{
				// Allocate Animated tile data
				AllocateAnimTileData( TileElement, 5 );

				TileElement->pAnimData->bCurrentFrame = 0;
				for (ubLoop = 0; ubLoop < TileElement->pAnimData->ubNumFrames; ubLoop++)
				{
					TileElement->pAnimData->pusFrames[ubLoop] = uiDatabaseElem + ubLoop;
				}
			}
			cnt++;
		};
		// Open Shadow
		cnt = 0;
		while( gOpenDoorShadowList[ cnt ] != -1 )
		{
			// IF WE ARE A SHADOW TYPE
			if ( uiDatabaseElem == gOpenDoorShadowList[ cnt ] )
			{
				// Allocate Animated tile data
				AllocateAnimTileData( TileElement, 5 );

				TileElement->pAnimData->bCurrentFrame = 0;
				for (ubLoop = 0; ubLoop < TileElement->pAnimData->ubNumFrames; ubLoop++)
				{
					TileElement->pAnimData->pusFrames[ubLoop] = uiDatabaseElem + ubLoop;
				}
			}
			cnt++;
		};

		// Closed
		cnt = 0;
		while( gClosedDoorList[ cnt ] != -1 )
		{
			// IF WE ARE A SHADOW TYPE
			if ( uiDatabaseElem == gClosedDoorList[ cnt ] )
			{
				// Allocate Animated tile data
				AllocateAnimTileData( TileElement, 5 );

				TileElement->pAnimData->bCurrentFrame = 0;
				for (ubLoop = 0; ubLoop < TileElement->pAnimData->ubNumFrames; ubLoop++)
				{
					TileElement->pAnimData->pusFrames[ubLoop] = uiDatabaseElem - ubLoop;
				}
			}
			cnt++;
		};
		// Open Shadow
		cnt = 0;
		while( gClosedDoorShadowList[ cnt ] != -1 )
		{
			// IF WE ARE A SHADOW TYPE
			if ( uiDatabaseElem == gClosedDoorShadowList[ cnt ] )
			{
				// Allocate Animated tile data
				AllocateAnimTileData( TileElement, 5 );

				TileElement->pAnimData->bCurrentFrame = 0;
				for (ubLoop = 0; ubLoop < TileElement->pAnimData->ubNumFrames; ubLoop++)
				{
					TileElement->pAnimData->pusFrames[ubLoop] = uiDatabaseElem - ubLoop;
				}
			}
			cnt++;
		};
	}

	if ( uiDatabaseElem == gFirstTileOfType[FIRSTMISS] ) 
	{
		// Allocate Animated tile data
		AllocateAnimTileData( TileElement, 5 );

		TileElement->pAnimData->bCurrentFrame = 0;
		for (ubLoop = 0; ubLoop < TileElement->pAnimData->ubNumFrames; ubLoop++)
		{
			TileElement->pAnimData->pusFrames[ubLoop] = uiDatabaseElem + ubLoop;
		}
	}

	if ( uiDatabaseElem >= gFirstTileOfType[FIRSTMISS] && 
			 uiDatabaseElem <= (gFirstTileOfType[FIRSTMISS]+4) )
	{ 
		TileElement->uiFlags |= DYNAMIC_TILE;
	}


	if ( uiDatabaseElem == gFirstTileOfType[WINDOWSHATTER] || uiDatabaseElem == (gFirstTileOfType[WINDOWSHATTER]+5) || uiDatabaseElem == (gFirstTileOfType[WINDOWSHATTER]+10) || uiDatabaseElem == (gFirstTileOfType[WINDOWSHATTER]+15) ) 
	{
		// Allocate Animated tile data
		AllocateAnimTileData( TileElement, 5 );

		TileElement->pAnimData->bCurrentFrame = 0;
		for (ubLoop = 0; ubLoop < TileElement->pAnimData->ubNumFrames; ubLoop++)
		{
			TileElement->pAnimData->pusFrames[ubLoop] = uiDatabaseElem + ubLoop;
		}
	}

	if ( uiDatabaseElem >= gFirstTileOfType[WINDOWSHATTER] && 
			 uiDatabaseElem <= (gFirstTileOfType[WINDOWSHATTER]+19) )
	{ 
		TileElement->uiFlags |= DYNAMIC_TILE;
	}

//	if ( usType == FIRSTEXPLOSION )
//	{ 
//		TileElement->uiFlags |= DYNAMIC_TILE;
//	}

	if ( usType == BODYEXPLOSION )
	{ 
		TileElement->uiFlags |= DYNAMIC_TILE;
	}

	if ( usType == FIRSTROAD )
	{
		TileElement->uiFlags |= ROAD_TILE;
	}

	// SET FLAGS FOR OBJECTS PEICES WHICH USE PROPER Z
	if ( fUseRaisedObjectType )
	{ 
		TileElement->uiFlags |= OBJECTLAYER_USEZHEIGHT;
	}

	
	// OFFSET SLANTED ROOFS TO HEIGHT OF WALLS
	if ( uiDatabaseElem >= gFirstTileOfType[FIRSTROOF] && 
			 uiDatabaseElem <= (gFirstTileOfType[SECONDSLANTROOF]+19) )
	{ 
		//TileElement->sOffsetHeight = WALL_HEIGHT;
	}

	// Set flag for full 3d tiles, as well as the dynamic flag for the folliage
	if ( uiDatabaseElem >= (gFirstTileOfType[FIRSTFULLSTRUCT]) && 
			 uiDatabaseElem <= (gFirstTileOfType[SECONDFULLSTRUCT]+11) )
	{ 
		//TileElement->uiFlags |= FULL3D_TILE;
		sIndexDiff = uiDatabaseElem - gTileTypeStartIndex[ usType ];

		// Every second set as dynamic
		if ( ( ( sIndexDiff ) % 3 ) == 1 )
		{
			TileElement->uiFlags |= DYNAMIC_TILE;
		}

		// Set every first as full tile
		if ( ( ( sIndexDiff ) % 3 ) == 0 )
		{
			TileElement->uiFlags |= FULL3D_TILE;
		}

	}

	//Ignore height for cliffs ie: if we rasie the land, do not offset the cliff
	if ( uiDatabaseElem >= gFirstTileOfType[FIRSTCLIFFHANG] && 
			 uiDatabaseElem <= (gFirstTileOfType[FIRSTCLIFFSHADOW]+16) )
	{ 
		if ( usType == FIRSTCLIFFHANG )
		{
			TileElement->uiFlags |= CLIFFHANG_TILE;
		}
		TileElement->uiFlags |= IGNORE_WORLD_HEIGHT;

	}

	if ( uiDatabaseElem >= gFirstTileOfType[FIRSTWALL] && 
			 uiDatabaseElem <= (gFirstTileOfType[FOURTHWALL]+64) )
	{ 
		TileElement->uiFlags |= WALL_TILE;
	}

	// Set a-frames heigher!
	if ( uiDatabaseElem >= gFirstTileOfType[FIRSTWALL] && 
			 uiDatabaseElem <= (gFirstTileOfType[FOURTHWALL]+46) )
	{ 

		// Set these ones higher ( for roof pieces )
		if ( uiDatabaseElem  >= ( gTileTypeStartIndex[ usType ] + WALL_AFRAME_START ) && 
				 uiDatabaseElem  <= ( gTileTypeStartIndex[ usType ] + WALL_AFRAME_END ) )
		{
			//TileElement->sOffsetHeight = WALL_HEIGHT;
			TileElement->uiFlags |= AFRAME_TILE;
		}


	}

	// Set UI Elements to be dynamic
	if ( uiDatabaseElem >= gFirstTileOfType[FOOTPRINTS] && 
			 uiDatabaseElem <= (gFirstTileOfType[THIRDPOINTERS]+1) )
	{ 
		TileElement->uiFlags |= DYNAMIC_TILE;
		TileElement->uiFlags |= OBJECTLAYER_USEZHEIGHT;
	}

	// Set UI Elements to use object z level
	if ( usType >= FOOTPRINTS && 
			 usType <= LASTUIELEM )
	{ 
		TileElement->uiFlags |= OBJECTLAYER_USEZHEIGHT;
	}

	// Set UI Elements to use object z level
	if ( usType >= HUMANBLOOD && 
			 usType <= CREATUREBLOOD )
	{ 
		TileElement->uiFlags |= OBJECTLAYER_USEZHEIGHT;
	}


	// Set UI Elements to use object z level
	//<SB> 0.98b19
	if ( usType >= GUNS && usType <= P2ITEMS || usType == P3ITEMS || usType >= P4ITEMS && usType <= P63ITEMS )
	{ 
		TileElement->uiFlags |= OBJECTLAYER_USEZHEIGHT;
	}
	//</SB>

	if ( usType >= FIRSTEXPLDEBRIS && usType <= SECONDEXPLDEBRIS )
	{
		TileElement->uiFlags |= OBJECTLAYER_USEZHEIGHT;
	}

	if ( uiDatabaseElem >= gFirstTileOfType[FIRSTDOOR] && 
			 uiDatabaseElem <= (gFirstTileOfType[FOURTHDOORSHADOW]+19) )
	{ 
		//TileElement->uiFlags |= DYNAMIC_TILE;
	}

	// Set UI Elements to be dynamic
	if ( uiDatabaseElem == gFirstTileOfType[MOCKFLOOR] ) 
	{ 
		TileElement->uiFlags |= DYNAMIC_TILE;

	}


	if ( usType == BULLETTILE ) 
	{ 
		TileElement->uiFlags |= DYNAMIC_TILE;
	}

	if ( usType == WIREFRAMES ) 
	{ 
		//TileElement->uiFlags |= DYNAMIC_TILE;
	}

	// Set full tile flag for floors
	if ( uiDatabaseElem >= gFirstTileOfType[FIRSTFLOOR] && 
			 uiDatabaseElem <= (gFirstTileOfType[FOURTHFLOOR]+7) )
	{ 
		TileElement->ubFullTile = 1;
	}

	if ( uiDatabaseElem >= gFirstTileOfType[FIRSTTEXTURE] &&
			 uiDatabaseElem <= (gFirstTileOfType[DEEPWATERTEXTURE]+9) )
	{
		// Set tile 'fullness' attribute
		TileElement->ubFullTile = gFullBaseTileValues[ uiDatabaseElem ];
	}

	if ( usType >= FIRSTONROOF && usType <= SECONDONROOF )
	{
		// Set height!
		//TileElement->sOffsetHeight = WALL_HEIGHT;
	}

	if ( uiDatabaseElem >= (gFirstTileOfType[REGWATERTEXTURE]+17) && uiDatabaseElem <= (gFirstTileOfType[REGWATERTEXTURE]+50) || uiDatabaseElem == REGWATERTEXTURE ||
			 uiDatabaseElem == (gFirstTileOfType[REGWATERTEXTURE]+11) || uiDatabaseElem == (gFirstTileOfType[REGWATERTEXTURE]+13) || uiDatabaseElem == (gFirstTileOfType[REGWATERTEXTURE]+15) )
	{
		TileElement->ubTerrainID			= FLAT_GROUND;
	}

	if ( ( usType >= FIRSTROOF && usType <= SECONDSLANTROOF ) || usType == FIRSTHIGHROOF || usType == SECONDHIGHROOF )
	{
		TileElement->uiFlags |= ROOF_TILE;
	}
}

